<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="robots" content="noindex, nofollow"/>
  <title>Search and Replace Files (Dark Mode)</title>
  <style>
    * {
      box-sizing: border-box;
    }
    body {
      font-family: Arial, sans-serif;
      background: #121212;
      color: #f0f0f0;
      margin: 0;
      padding: 0;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
    }
    .container {
      background-color: #1e1e1e;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.5);
      border-radius: 12px;
      overflow: hidden;
      width: 600px;
      max-width: 90%;
      padding: 20px;
    }
    h2 {
      background: #007bff;
      color: #fff;
      padding: 12px;
      margin: -20px -20px 20px;
      text-align: center;
      font-size: 1.3rem;
      text-transform: uppercase;
    }
    textarea, input[type="text"], input[type="submit"], input[type="checkbox"] {
      width: 100%;
      padding: 10px;
      background: #252525;
      color: #f0f0f0;
      border: 1px solid #444;
      margin: 5px 0;
      font-size: 14px;
    }
    textarea {
      resize: none;
    }
    input[type="submit"] {
      background: #28a745;
      color: #fff;
      font-weight: bold;
      border: none;
      cursor: pointer;
      transition: background 0.3s;
    }
    input[type="submit"]:hover {
      background: #218838;
    }
    input[type="checkbox"] {
      width: auto;
      cursor: pointer;
    }
    .input-label {
      font-weight: bold;
      display: block;
      margin-bottom: 5px;
      color: #bbb;
    }
    .error {
      border: 1px solid #ff4d4d !important;
      background-color: #3a0000;
    }
    .result-box {
      background: #181818;
      border: 1px solid #555;
      padding: 10px;
      margin-top: 20px;
      font-family: monospace;
      max-height: 200px;
      overflow-y: auto;
      white-space: pre-wrap;
      color: #ff8080;
    }
    .time-taken {
      margin-top: 10px;
      text-align: center;
      font-weight: bold;
      color: #bbb;
    }
  </style>
</head>
<body>
<div class="container">
  <h2>Search and Replace Tool (Dark Mode)</h2>
  <?php
    $err_arr = array(0 => '', 1 => '');
    if (isset($_POST['submit'])) {
      if ($_POST['text'] == '' || $_POST['dir'] == '') {
        $err = ' class="error"';
        if ($_POST['text'] == '') $err_arr[0] = $err;
        if ($_POST['dir'] == '') $err_arr[1] = $err;
      } else {
        set_time_limit(0);
        error_reporting(E_ALL);

        $dir = trim($_POST['dir']);
        $text = stripslashes($_POST['text']);
        $retext = stripslashes($_POST['retext']);
        $replace = isset($_POST['replace']) ? $_POST['replace'] : 0;
        $ext = explode(',', $_POST['ext']);
        $cnt = 0;

        function scan_dir($dirname) {
          global $text, $retext, $replace, $ext, $cnt;

          $dir = opendir($dirname);
          while (($file = readdir($dir)) !== false) {
            if ($file != "." && $file != "..") {
              $file_name = $dirname . "/" . $file;
              if (is_file($file_name)) {
                $ext_name = pathinfo($file_name, PATHINFO_EXTENSION);
                if (in_array($ext_name, $ext) || basename($file_name) == 'search_replace.php')
                  continue;

                $content = file_get_contents($file_name);
                if (strpos($content, $text) !== false) {
                  $cnt++;
                  if ($replace) {
                    $content = str_replace($text, $retext, $content);
                    file_put_contents($file_name, $content);
                  }
                  echo $cnt . ': ' . $file_name . "\n";
                }
              }
              if (is_dir($file_name)) {
                scan_dir($file_name);
              }
            }
          }
          closedir($dir);
        }

        $start_time = microtime(true);
        echo '<div class="result-box"><strong>' . ($replace ? 'Replacing Text:' : 'Searching for Text:') . "</strong>\n";
        scan_dir($dir);
        if (!$cnt) echo "No matches found.";
        echo '</div>';
        $exec_time = microtime(true) - $start_time;
        echo '<div class="time-taken">Time Taken: ' . number_format($exec_time, 4) . ' sec</div>';
      }
    }
  ?>

  <form method="post">
    <div class="input-label">Text to Search*</div>
    <textarea name="text" rows="4" <?= $err_arr[0] ?>><?php echo isset($text) ? htmlentities($text) : ''; ?></textarea>

    <div class="input-label">Text to Replace (optional)</div>
    <textarea name="retext" rows="4"><?php echo isset($retext) ? htmlentities($retext) : ''; ?></textarea>

    <div>
      <label><input type="checkbox" name="replace" value="1" <?= isset($replace) && $replace == 1 ? 'checked' : ''; ?>> Replace Text</label>
    </div>

    <div class="input-label">Excluded File Extensions (comma separated)</div>
    <input type="text" name="ext" value="<?php echo isset($_POST['ext']) ? $_POST['ext'] : 'gif,jpg,jpeg,png,zip,rar,pdf,css,flv,mp3,js,htm,xml,swf,doc,mpg,sxw,cdr,ini,txt,sql,xls,shtml,tmp'; ?>">

    <div class="input-label">Folder Path*</div>
    <input type="text" name="dir" <?= $err_arr[1] ?> value="<?php echo isset($dir) ? $dir : '.'; ?>">

    <input type="submit" name="submit" value="Search / Replace">
  </form>
</div>
</body>
</html>
